'use strict';

/* --------------------------------------------------------------
 language_selection.js 2016-06-03
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2016 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

gx.controllers.module('language_selection', [jse.source + '/vendor/jquery-deparam/jquery-deparam.min.js'], function (data) {

        'use strict';

        // ------------------------------------------------------------------------
        // VARIABLES
        // ------------------------------------------------------------------------

        /**
         * Module Selector
         *
         * @type {jQuery}
         */

        var $this = $(this);

        /**
         * Module Instance
         *
         * @type {Object}
         */
        var module = {};

        // ------------------------------------------------------------------------
        // FUNCTIONS
        // ------------------------------------------------------------------------

        /**
         * On Language Link Click
         *
         * Prevent the default link behavior and regenerate the correct URL by taking into concern the dynamic
         * GET parameters (e.g. from table filtering).
         *
         * @param {jQuery.Event} event
         */
        function _onClickLanguageLink(event) {
                event.preventDefault();

                var currentUrlParameters = $.deparam(window.location.search.slice(1));

                currentUrlParameters.language = $(this).data('languageCode');

                window.location.href = window.location.pathname + '?' + $.param(currentUrlParameters);
        }

        // ------------------------------------------------------------------------
        // INITIALIZATION
        // ------------------------------------------------------------------------

        module.init = function (done) {
                $this.on('click', 'a', _onClickLanguageLink);
                done();
        };

        return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
